define([
    'backbone',
    'models/abstract-collection',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-collection',
    'User',
    'moment',
], function(Backbone, Collection, TimeSlotsCollection, user, moment) {
    'use strict';


    var ClinicTimeSlotsModel = Backbone.Model.extend({
        idAttribute: 'clinicId',
        defaults: {clinicName: ''},
        parse: function(response) {
            var slots = response.appointmentTimeSlot || [];

            response.appointmentTimeSlot = new TimeSlotsCollection(slots);

            return response;
        },
    });


    return Collection.extend({
        resourceName: 'available-appointment-slots',
        DATE_FORMAT: 'MM/DD/YYYY',
        model: ClinicTimeSlotsModel,


        /**
         * @param {string} siteCode The 3 digit code of the facility
         * @returns {void}
         */
        getUrl: function(siteCode) {
            var idType = user.get('idType');
            var id = user.get('id');
            var resource = this.getResource();

            return resource.formatHref({
                'site-code': siteCode,
                'assigning-authority': idType,
                'patient-id': id,
            });
        },

        /**
         * @return {string} Tomorrows date in DATE_FORMAT
         */
        getStartDate: function() {
            var today = moment();
            var tomorrow = today.add(1, 'days');
            return tomorrow.format(this.DATE_FORMAT);
        },

        /**
         * @return {string} 90 days from now in DATE_FORMAT
         */
        getEndDate: function() {
            var today = moment();
            var daysFromNow = 90;
            var later = today.add(daysFromNow, 'days');
            return later.format(this.DATE_FORMAT);
        },

        fetchData: function(siteCode, clinicIds) {
            var options = {
                data: this.getFetchData(clinicIds),
                url: this.getUrl(siteCode),
            };

            return this.fetch(options);
        },

        /**
         * A wrapper for create the fetch options.data object
         * @param {string} clinicIds A comma delimited string with each clinic to check for appointments
         * @return {{startDate: (*|string), endDate: (*|string), clinicIds: *}}
         */
        getFetchData: function(clinicIds) {
            return {
                startDate: this.getStartDate(),
                endDate: this.getEndDate(),
                clinicIds: clinicIds,
            };
        },
    });
});
